import pandas as pd  
from sklearn.model_selection import train_test_split  
from sklearn.preprocessing import LabelEncoder  
from sklearn.linear_model import LogisticRegression  
from sklearn.metrics import confusion_matrix, accuracy_score
import pickle  
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Convert categorical features to numerical values  
le = LabelEncoder()  
credit_customers['credit_history'] = le.fit_transform(credit_customers['credit_history'])  
credit_customers['employment'] = le.fit_transform(credit_customers['employment'])  
credit_customers['class'] = le.fit_transform(credit_customers['class'])  
  
# Select features and target  
X = credit_customers[['credit_history', 'employment', 'age', 'credit_amount']]  
y = credit_customers['class']  
  
# Split the dataset into training and testing sets  
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)  
  
# Train a logistic regression classifier  
clf = LogisticRegression()  
clf.fit(X_train, y_train)  
  
# Make predictions on the testing set  
y_pred = clf.predict(X_test)  
  
# Calculate the confusion matrix and accuracy  
cm = confusion_matrix(y_test, y_pred)  
acc = accuracy_score(y_test, y_pred)  
  
print("Confusion Matrix:\n", cm)  
pickle.dump(cm,open("./ref_result/Confusion_Matrix.pkl","wb"))
print("Accuracy:", acc) 
pickle.dump(acc,open("./ref_result/Accuracy.pkl","wb"))